# Distributed Energy Resources Topology Identifification via Graphical Modeling





随着分布式能源（DER）集成到配电网中，电力行业正在发生结构性变化。DER是小型电源，例如光伏（PV）和风力发电机（可再生发电），能量存储设备（消费灵活性）和电力车辆（车辆到电网）。384 / 5000

## 翻译结果

由于它们有潜力为最终用户提供更多选择，更清洁的能源以及对能源账单的更多控制，因此DER的部署正在全球范围内获得发展势头[1]。例如，SunShot Vision Study估计，太阳能发电系统将迅速扩展，到2030年可能会产生全国总电力需求的14％，到2050年产生27％的电力[2]，[3]。

The electric industry is undergoing structural changes as distributed energy resources (DERs) are integrated into the distribution grid. DERs are small power sources such as photovoltaic (PV) and wind generators (renewable generation), energy storage devices (consumption flexibility), and electric vehicles (vehicle-to-grid services). As they have the potential to offer end-consumers more choices, cleaner power, and more control over energy bills, the  deployment of DER is gaining momentum on a worldwide scale [1]. For example, SunShot Vision Study estimates that solar electric system will scale rapidly and potentially generate up to 14% of the nation’s total electricity demand by 2030 and 27% by 2050 [2], [3].

在增加新功能的同时，DER的扩散引起了人们对电网弹性的极大关注。 例如，曾经在配电系统上单向流动的电力-从中央发电厂到客户-现在也从客户流回配电网。 电压曲线的动态变化，电压稳定性，孤岛，线路工作危险以及在稳定边界运行的配电系统也困扰着配电网的运行[4]。 这些问题迫使电力系统工程师重新考虑电网架构，并从传统的自上而下的方法过渡到自下而上的设计，因为大多数更改都发生在客户级别[5]。 结果，创建了配电自动化的概念，以提供对配电网格级别和客户级别的智能控制，以实现可持续的电网运行[6]。

While adding new capabilities, the DER proliferation raises  great concern about the resilience of power grid. For example,  power that used to flow in one direction on the distribution  system - from central power plants to customers - is now also  flowing back from customers to the distribution grid. Dynamic  variation of voltage profiles, voltage stability, islanding, line  work hazards, and distribution system operating at stability  boundaries are also troubling the distribution grid operation  [4]. Such problems are forcing power system engineers to  rethink the architecture of power grid and transition from the  traditional top-down approach to a bottom-up design since  most changes happen at the customer level [5]. As a result,  the concept of distribution automation is created to provide intelligent control over distribution grid level and customer level for sustainable grid operation [6].

为了实现配电自动化，需要对DER进行可靠且连续的监控，因为它可以使操作员了解可能发生反向功率流动的地方。例如，处于战略位置时，DER可能会推迟或替代常规基础设施[1]。因此，了解现有连通性是计算位置效益分析和未来规划目的的本地电网容量分析的关键[1]。此外，事故分析需要连接的分布式能源，因为它们有助于回答“如果什么”的问题，例如，如果太阳能发电量提高20％[7]是什么？ 最后，屋顶太阳能电池板可能会改变公用事业的收入，因此一些公用事业想知道他们在哪里[8]。

To achieve distribution automation, reliable and continuous monitoring of DERs is needed as it allows operators to know where the reverse power flow may happen. For example, when strategically located, DERs could potentially defer or substitute for conventional infrastructure [1]. So, understanding existing connectivity serves as a key for calculating locational benefit analysis and local grid capacity analysis for future planning purpose [1]. Further, contingency analysis needs DERs connectivity, as they help answer “what if” questions, e.g., what if solar capacity is increased by 20% [7]? Finally, rooftop solar panel may change the revenue of utilities, so some utilities want to know where they are [8].

DER监视的主要挑战是配电网的拓扑结构很难获得。例如，许多变电站依靠的物理拓扑图可能已经过时。这是因为，与输电电网[9]，[10]不同，配电网可能会发生频繁的拓扑变化[11]-[14]。对于中压配电网，这种拓扑变化可以是一次[15]一次，也可以是4周一次[16]。如果需要协调光伏，则频率可以是每8小时一次[17]。某些已知的更改是例行重新配置的结果，例如，故意和动态地更改网络以从城市网络中潜在的网格状分布拓扑中获取最佳的径向拓扑[18]，[19]。由中断或手动维护引起的许多其他更改可能是未知的。例如，在修复部分网络后，现场工程师可能不会立即报告拓扑更改[20]。另外，即使在本地已知或检测到拓扑变化，也可能难以获得确切的变化[21]。最后，尽管使用了拓扑传感器，但由于预算限制，它们仅被放置在特殊的位置[22]。

A major challenge of DER monitoring is that the topology  of the distribution grid is difficult to obtain. For example,  many substations rely on a physical topology map, which may  be outdated. This is because, unlike the transmission power  grid [9], [10], a distribution grid can have frequent topology  changes [11]–[14]. Such a topology change can be once a  season [15] or once 4 weeks for MV grids [16]. If one needs  to coordinate PV, the frequency can be once per 8 hours [17].  Some known changes are results of routine reconfiguration,  e.g., deliberately and dynamically change of the network for  best radial topology from the potentially meshed distribution  topology in city networks [18], [19]. Many other changes  caused by outages or manual maintenance may be unknown.  For example, a field engineer may not report immediately  about topology changes after repairing part of a network [20].  Additionally, even if a topology change is known or detected  in the local area, the exact change may be hard to obtain [21].  Finally, although topology sensors are being used, they are  placed only at special locations due to budget constraints [22].

在数学上，可以通过电压估算来实现拓扑识别[23]。 但是，这种方法将在传感器数据有限或拓扑变化相对频繁的配电网中失败[24]-[27]。 也有基于不同假设的配电网专用方法。 例如，[28] – [30]假定所有开关位置均可用，并搜索正确的组合。 基于状态估计的方法[31]，[32]和基于潮流的方法[33]假定导纳矩阵的可用性和不频繁的拓扑变化。 不幸的是，这些假设在新添加或重新配置的配电网络中是不合适的，因为断路器的知识和导纳矩阵的信息都不可用。

Mathematically, topology identification can be achieved via  voltage estimation [23]. But such an approach will fail in a  distribution grid with limited sensor data or relatively frequent  topological changes [24]–[27]. There are also methods dedicated for distribution grid based on different assumptions. For example, [28]–[30] assume the availability of all switch locations and search for the right combination. State estimation-based methods [31], [32] and power flow-based methods [33] assume the availability of admittance matrix and infrequent topology change. Unfortunately, these assumptions are improper in newly added or reconfigured distribution network, because neither the knowledge of circuit breakers nor the information of admittance matrix may be available.

幸运的是，由于通信，传感和有针对性的政府投资的最新进展，智能传感器已在整个配电系统中不断部署[34]，[35]。 一些传感器示例包括高级计量基础架构（AMI）和负载侧微型PMU（µ-PMU）[36]。 基于它们，统计方法可用于校正城市网络拓扑[18]，[19]。 此外，私营企业正在将传感功能集成到DER中以进行监控，例如，Solar City的光伏系统[37]，商业和住宅充电系统以及恒温器等家用电器。 问题在于，这样的数据流没有被分配系统运营商集成或利用以改善系统性能，例如DER拓扑结构识别。

Fortunately, smart sensors are continuously being deployed  across distribution systems [34], [35], thanks to recent advances in communications, sensing and targeted government  investments. Some sensor examples include advanced metering  infrastructure (AMI) and load side micro-PMUs (µ-PMUs)  [36]. Based on them, statistical methods can be used to  correct city network topology [18], [19]. Additionally, private  industries are integrating sensing capability into DERs for  monitoring purpose, e.g., Solar City’s photovoltaic systems  [37], commercial and residential charging systems, and inhome appliances such as thermostats. The problem is that  such data streams are not integrated or utilized by distribution  system operators to improve system performance, e.g., DER  topology identification.

在本文中，我们建议利用此类数据流来重构DER的连通性，以实现配电自动化[38]，[39]。 我们在两种情况下工作。 一是长期缺乏拓扑状态观察。 在这种情况下，部分网络拓扑可能是未知的或不正确的，因此需要确认现有的网络结构或纠正拓扑错误。 另一种情况是了解新安装的DER与现有网格之间的未知连通性。 例如，虽然公用事业公司可能不拥有DER设备，但他们可以尝试从制造商（如太阳能城市）获取传感器数据以进行连接性识别。

In this paper, we propose to utilize such data streams to  reconstruct DERs’ connectivity for distribution automation  [38], [39]. We work on two scenarios. One is the chronic  lack of topology state observation. In this case, partial network  topology may be unknown or incorrect, so one needs to  confirm existing network structure or correct topology errors.  The other scenario is to understand the unknown connectivity  of newly installed DERs to the existing grid. For example,  while the utilities may not own the DER devices, they can try  to obtain the sensor data from manufactures such as solar city  for connectivity identification.

具体而言，我们建立了电网的概率图形模型，以对相邻总线之间的依赖性进行建模。 随后，我们通过Kullback-Leibler（KL）散度度量将拓扑识别问题公式化为概率距离最小化问题。 我们证明，如果假设当前注入近似独立，则最终基于互信息的算法可以找到最佳拓扑连接[40]。 由于这种算法仅依靠传感器数据且计算上不昂贵（无需考虑断路器条件和系统导纳矩阵[25]），因此可以正确识别许多即插即用设备。 最后，我们在树状网络中推广了使用条件互信息来处理循环的方法。

Specifically, we build a probabilistic graphical model of  the power grid to model the dependency between neighbor  buses. Subsequently, we formulate the topology identification  problem as a probability distance minimization problem via  the Kullback-Leibler (KL) divergence metric. We prove that  the resulting mutual information-based algorithm can find the  optimal topology connection [40] if current injections are assumed to be approximately independent. As such an algorithm  relies on sensor data only and computationally inexpensive  (no need to consider circuit breaker conditions and system  admittance matrix [25]), many plug-and-play devices can be  identified correctly. Finally, we generalize the method in the  tree network to deal with loops by using conditional mutual  information.

数据驱动方法的性能通过标准IEEE 8和123总线分布测试案例[41]-[43]以及电力研究所（EPRI）13、34、37和2998-的仿真得到了验证。 总线系统。 使用了两个数据集，分别是北加利福尼亚的123，000个居民家庭（PG＆E）和上奥地利州的30个房屋[44]。 通过MATLAB Power System Simulation软件包（MATPOWER）[42]，[43]和OpenDSS [45]进行仿真。 仿真结果表明，在提供足够的历史数据的情况下，数据驱动的拓扑估计优于传统方法的估计。

The performance of the data-driven method is verified by  simulations on the standard IEEE 8- and 123-bus distribution  test cases [41]–[43], and Electric Power Research Institute  (EPRI) 13, 34, 37, and 2998-bus systems. Two data sets of  123, 000 residential households (PG&E) in the North California and 30 houses in Upper-Austria are used [44]. Simulations  are conducted via MATLAB Power System Simulation Package (MATPOWER) [42], [43] and OpenDSS [45]. Simulation  results show that, provided with enough historical data, the  data-driven topology estimate outperforms the estimates from  the traditional approaches.

本文的其余部分安排如下：第二部分介绍了建模和数据驱动的拓扑识别问题。 第三节使用证明来证明基于互信息的算法在配电系统拓扑重构中的适用性。 还说明了详细的算法。 第四节评估了新方法的性能，第五节总结了本文

The rest of the paper is organized as follows: Section II introduces the modeling and the problem of data-driven topology identification. Section III uses a proof to justify the  applicability of mutual information-based algorithm for distribution system topology re-configuration. A detailed algorithm  is illustrated as well. Section IV evaluates the performance of  the new method and Section V concludes the paper

## PROBABILISTIC MODELING OF NETWORK VOLTAGES VIA GRAPHICAL MODELING

在本节中，我们首先将传感器测量值描述为随机变量。 有了这样的定义，我们就可以通过概率图形模型对配电网进行建模。 基于此建模，我们正式定义了数据驱动的拓扑识别问题。

In this section, we first describe sensor measurements as  random variables. With such a definition, we model the distribution grid via a probabilistic graphical model. Based on  this modeling, we formally define the problem of data-driven  topology identification.

对于建模，配电网被定义为物理图G(V,E)，其中顶点V={1,...n}表示母线（光伏发电，储能设备和负载），边E表示它们之间的相互联系。可视化为图1所示物理层。为了利用智能电表生成的时间序列，我们构造了一个一个用户网络拓扑重建的网络
$$
层，其中每个节点均与一个随机变量V_{cyber}相关。因此可以将母线i和时间t表示为v_i(t)。\\我们使用联合概率分布表示不同电压随机变量V_{cyber}之间的相互依赖性。\\
p(v)=p(v_1,v_2,...,v_n)=p(v_2)p(v_3|v_2)...p(v_n|v_2,...,v_{n-1})\\
其中v_i表示母线i的电压测量值，母线1表示参考母线，单位幅值和0相角。\\
若量化母线电压具有m个level，每个需要储存和处理m^{n-1}个离散可能性分布。
$$
对于大型系统中的边际分布或最大关节分布而言，这在计算上是昂贵的。因此，我们希望使用合理数量的指定值来近似分布，这些指定值可以捕获物理层中的主要依赖性[46]（边E）。例如，我们可以用另一个简化的分布pa（v）近似真实分布p（v）。 在下一节中，我们将显示当当前注入独立时，这样的近似是精确的，没有近似误差

## Conclusion

为了确定分布式能源的连通性，我们提出了一种基于传感器测量的数据驱动方法。 与需要了解断路器或导纳矩阵的现有方法不同，我们提出的算法仅依赖于智能计量数据。 在图形模型框架下，我们将拓扑重构问题公式化为联合分布（电压相量）近似问题。 基于我们关于如何最小化配电系统中Kullback-Leibler散度的证明，提出了一种基于互信息的最大权重生成树算法。 此外，我们将算法从树结构扩展到循环结构以概括其用法。 最后，我们在IEEE 8和123总线系统以及EPRI 13、34、37和2998总线系统上模拟提出的算法，与过去的方法进行比较，并观察到有无分布式能源情况下的高精度检测结果。

In order to identify distributed energy resources’ connectivity, we propose a data-driven approach based on sensor  measurements. Unlike existing approaches, which require the  knowledge about circuit breakers or the admittance matrix,  our proposed algorithm relies on smart metering data only.  We formulate the topology reconstruction problem as a joint  distribution (voltage phasors) approximation problem under  the graphical model framework. A mutual information-based  maximum weight spanning tree algorithm is proposed based on  our proof of how to minimizing Kullback-Leibler divergence  in a distribution system. Moreover, we extend our algorithm  from tree structures to loopy structures to generalize the  usage. Finally, we simulate the proposed algorithm on IEEE  8- and 123-bus systems and EPRI 13-, 34-, 37-, and 2998-  bus systems, compare with past methods, and observe highly  accurate detection results in cases with and without distributed  energy resources.

